/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Queue;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.util.serial.Serial;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SerialDriver;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.ToolModel;
import replicatorg.util.Point5d;

public class SerialPassthroughDriver
extends SerialDriver {
    private Queue<Integer> commands;
    private int maxBufferSize = 128;
    private int bufferSize = 0;
    private String result = "";
    private DecimalFormat df;
    private byte[] responsebuffer = new byte[512];

    public SerialPassthroughDriver() {
        this.commands = new LinkedList<Integer>();
        this.setInitialized(false);
        this.df = new DecimalFormat("#.######");
    }

    @Override
    public void loadXML(Node xml) {
        super.loadXML(xml);
    }

    @Override
    public void initialize() {
        if (this.serial == null) {
            Base.logger.severe("No Serial Port found.\n");
            return;
        }
        if (!this.isInitialized()) {
            try {
                Date date = new Date();
                long end2 = date.getTime() + 10000L;
                Base.logger.info("Initializing Serial.");
                while (!this.isInitialized()) {
                    this.readResponse();
                    date = new Date();
                    long now = date.getTime();
                    if (now <= end2) continue;
                    Base.logger.warning("Serial link non-responsive.");
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Base.logger.info("Ready.");
        }
        this.sendCommand("G90");
    }

    @Override
    public boolean isPassthroughDriver() {
        return true;
    }

    @Override
    public void executeGCodeLine(String code) {
        this.sendCommand(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void sendCommand(String next) {
        if (!SerialPassthroughDriver.$assertionsDisabled && !this.isInitialized()) {
            throw new AssertionError();
        }
        if (!SerialPassthroughDriver.$assertionsDisabled && this.serial == null) {
            throw new AssertionError();
        }
        if ((next = this.clean(next)).length() != 0) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            this.readResponse();
lbl8:
            // 2 sources

            ** while (this.bufferSize + next.length() + 1 > this.maxBufferSize)
        }
lbl9:
        // 1 sources

        var2_2 = this.serial;
        synchronized (var2_2) {
            this.serial.write(String.valueOf(next) + "\n");
        }
        cmdlen = next.length() + 1;
        this.commands.add(cmdlen);
        this.bufferSize += cmdlen;
    }

    public String clean(String str) {
        String clean = str;
        clean = clean.trim();
        clean = clean.replaceAll(" ", "");
        return clean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readResponse() {
        assert (this.serial != null);
        Serial serial = this.serial;
        synchronized (serial) {
            try {
                int index;
                int numread = this.serial.read(this.responsebuffer);
                if (numread < 0) {
                    Base.logger.severe("SerialPassthroughDriver.readResponse(): EOF occured");
                    return;
                }
                this.result = String.valueOf(this.result) + new String(this.responsebuffer, 0, numread, "US-ASCII");
                while ((index = this.result.indexOf(10)) >= 0) {
                    String line = this.result.substring(0, index).trim();
                    this.result = this.result.substring(index + 1);
                    if (line.length() == 0) continue;
                    if (line.startsWith("ok")) {
                        this.bufferSize -= this.commands.remove().intValue();
                        Base.logger.info(line);
                        continue;
                    }
                    if (line.startsWith("T:")) {
                        String temp = line.substring(2);
                        this.machine.currentTool().setCurrentTemperature(Double.parseDouble(temp));
                        Base.logger.info(line);
                        continue;
                    }
                    if (line.startsWith("start")) {
                        this.setInitialized(true);
                        Base.logger.info(line);
                        continue;
                    }
                    if (line.startsWith("Extruder Fail")) {
                        this.setError("Extruder failed:  cannot extrude as this rate.");
                        Base.logger.severe(line);
                        continue;
                    }
                    Base.logger.severe("Unknown: " + line);
                }
            }
            catch (IOException e) {
                Base.logger.severe("inputstream.read() failed: " + e.toString());
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.isBufferEmpty();
    }

    @Override
    public boolean isBufferEmpty() {
        try {
            this.readResponse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.bufferSize == 0;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.commands = null;
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        String cmd = "G1 F" + this.df.format(this.getCurrentFeedrate());
        this.sendCommand(cmd);
        cmd = "G1 X" + this.df.format(p.x()) + " Y" + this.df.format(p.y()) + " Z" + this.df.format(p.z()) + " F" + this.df.format(this.getCurrentFeedrate());
        this.sendCommand(cmd);
        super.queuePoint(p);
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        this.sendCommand("G92 X" + this.df.format(p.x()) + " Y" + this.df.format(p.y()) + " Z" + this.df.format(p.z()));
        super.setCurrentPosition(p);
    }

    public void homeAxes(EnumSet<AxisId> axes) throws RetryException {
        StringBuffer buf = new StringBuffer("G28 ");
        if (axes.contains((Object)AxisId.X)) {
            buf.append("X");
        }
        if (axes.contains((Object)AxisId.Y)) {
            buf.append("Y");
        }
        if (axes.contains((Object)AxisId.Z)) {
            buf.append("Z");
        }
        this.sendCommand(buf.toString());
        super.homeAxes(axes, false, 0.0);
    }

    @Override
    public void delay(long millis) {
        int seconds = Math.round(millis / 1000L);
        this.sendCommand("G4 P" + seconds);
    }

    @Override
    public void openClamp(int clampIndex) {
        this.sendCommand("M11 Q" + clampIndex);
        super.openClamp(clampIndex);
    }

    @Override
    public void closeClamp(int clampIndex) {
        this.sendCommand("M10 Q" + clampIndex);
        super.closeClamp(clampIndex);
    }

    @Override
    public void enableDrives() throws RetryException {
        this.sendCommand("M17");
        super.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        this.sendCommand("M18");
        super.disableDrives();
    }

    @Override
    public void changeGearRatio(int ratioIndex) {
        int code = 40 + ratioIndex;
        code = Math.max(40, code);
        code = Math.min(46, code);
        this.sendCommand("M" + code);
        super.changeGearRatio(ratioIndex);
    }

    private String _getToolCode() {
        return "T" + this.machine.currentTool().getIndex() + " ";
    }

    @Override
    public void setMotorRPM(double rpm) throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M108 R" + this.df.format(rpm));
        super.setMotorRPM(rpm);
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M108 S" + this.df.format(pwm));
        super.setMotorSpeedPWM(pwm);
    }

    @Override
    public void enableMotor() throws RetryException {
        String command = this._getToolCode();
        command = this.machine.currentTool().getMotorDirection() == ToolModel.MOTOR_CLOCKWISE ? String.valueOf(command) + "M101" : String.valueOf(command) + "M102";
        this.sendCommand(command);
        super.enableMotor();
    }

    @Override
    public void disableMotor() throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M103");
        super.disableMotor();
    }

    @Override
    public void setSpindleRPM(double rpm) throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "S" + this.df.format(rpm));
        super.setSpindleRPM(rpm);
    }

    @Override
    public void enableSpindle() throws RetryException {
        String command = this._getToolCode();
        command = this.machine.currentTool().getSpindleDirection() == ToolModel.MOTOR_CLOCKWISE ? String.valueOf(command) + "M3" : String.valueOf(command) + "M4";
        this.sendCommand(command);
        super.enableSpindle();
    }

    @Override
    public void disableSpindle() throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M5");
        super.disableSpindle();
    }

    @Override
    public void setTemperature(double temperature) throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M104 S" + this.df.format(temperature));
        super.setTemperature(temperature);
    }

    @Override
    public void readTemperature() {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M105");
        super.readTemperature();
    }

    @Override
    public void enableFloodCoolant() {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M7");
        super.enableFloodCoolant();
    }

    @Override
    public void disableFloodCoolant() {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M9");
        super.disableFloodCoolant();
    }

    @Override
    public void enableMistCoolant() {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M8");
        super.enableMistCoolant();
    }

    @Override
    public void disableMistCoolant() {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M9");
        super.disableMistCoolant();
    }

    @Override
    public void enableFan() throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M106");
        super.enableFan();
    }

    @Override
    public void disableFan() throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M107");
        super.disableFan();
    }

    @Override
    public void openValve() throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M126");
        super.openValve();
    }

    @Override
    public void closeValve() throws RetryException {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M127");
        super.closeValve();
    }

    @Override
    public void openCollet() {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M21");
        super.openCollet();
    }

    @Override
    public void closeCollet() {
        this.sendCommand(String.valueOf(this._getToolCode()) + "M22");
        super.closeCollet();
    }

    @Override
    public void reset() {
        Base.logger.info("Reset.");
        this.setInitialized(false);
        this.initialize();
    }

    @Override
    protected Point5d reconcilePosition() {
        return new Point5d();
    }
}

